import store from 'entry/store';
import { history } from 'entry/appHistory';
import {
  getAccountId,
  getAccountType,
  getAccountTabs,
} from 'pages/accounts/modules/info/selectors';

interface Meta {
  accountId: string;
  accountType: string;
  date: number;
  tabId?: string;
  tabCaption?: string;
}

export const accountCardDataCollector = async () => {
  const state = store.getState();
  const regV = /account\/[0-9]{2,10}\/[0-9]/;
  const currentTabId =
    regV.test(history.location.pathname) && history.location.pathname.split('/')[3];
  const tabs = getAccountTabs(state);
  const meta: Meta = {
    accountId: getAccountId(state),
    accountType: getAccountType(state),
    date: Date.now(),
  };

  if (currentTabId) {
    const currentTab = tabs.find((tab) => Number(tab.tabId) === Number(currentTabId));
    if (currentTab) {
      meta.tabId = currentTab.tabId;
      meta.tabCaption = currentTab.tabCaption;
    }
  }

  return meta;
};
