import { accountCardDataCollector } from './accountCardDataCollector';

class DataCollector {
  private collectors = {
    show_block_from_account_card: accountCardDataCollector,
  };

  public getDataByCollectorName = async (name: string) => {
    if (typeof this.collectors[name] === 'function') {
      return this.collectors[name]();
    }
  };
}

export const dataCollector = new DataCollector();
