import React, { ComponentType, useRef } from 'react';
import { useIntersectionWatching, Config } from '../hook/useIntersectionWatching';

export const withIntersectionWatcher = <WCProps extends {}>(
  WC: ComponentType<WCProps>,
  intersectionObservableConfig: Config,
) => (props: WCProps) => {
  const nodeRef = useRef<HTMLDivElement>(null);
  useIntersectionWatching(intersectionObservableConfig, nodeRef);
  return (
    <div ref={nodeRef}>
      <WC {...props} />
    </div>
  );
};
