import { RefObject, useEffect } from 'react';
import intersectionWatcher from '../IntersectionWatcher';
import { LocalMeta } from '../IntersectionWatcher.types';

export interface Config {
  observerName: string;
  localMeta?: LocalMeta;
}

export const useIntersectionWatching = (config: Config, nodeRef: RefObject<Element>) => {
  const { localMeta = {} } = config;
  useEffect(() => {
    if (nodeRef.current) {
      intersectionWatcher.addObservable(config.observerName, nodeRef.current, localMeta);
    }

    return () => {
      if (nodeRef.current) {
        intersectionWatcher.removeObservable(config.observerName, nodeRef.current);
      }
    };
  }, []);
};
