import RumProvider from 'services/Rum/RumProvider/RumProvider';
import guid from 'utils/guid';
import { dataCollector } from '../dataCollector';

export const sendIntersectionTimeMark = async (
  eventName: string,
  localMeta: { [k: string]: string } = {},
) => {
  const meta = await dataCollector.getDataByCollectorName(eventName);
  const eventId = guid();
  const unionMeta = { event: { eventName, eventId, ...meta, ...localMeta } };
  RumProvider.sendTimeMark(eventName, Date.now(), unionMeta);
};
