import { makeObservable, observable } from 'mobx';
import { LoadMeta } from 'types/LoadMeta';
import { LoadState } from 'types/LoadState';

export class LoadMetaImpl<Data> implements LoadMeta<Data> {
  public data?: Data;
  public state?: LoadState;
  public error?: Error;

  constructor() {
    makeObservable(this, {
      data: observable,
      state: observable,
      error: observable,
    });
  }
}
