import { makeObservable, action, runInAction } from 'mobx';
import Bluebird from 'bluebird';
import { Loadable } from 'types/Loadable';
import { Destroyable } from 'types/Destroyable';
import { LoadMeta } from 'types/LoadMeta';
import { LoadState } from 'types/LoadState';
import { LoadCallback } from 'types/LoadCallback';

export class Loader<Data> implements Loadable<Data>, Destroyable {
  promise: Bluebird<Data>;

  constructor(public meta: LoadMeta<Data>, private onLoad: LoadCallback<Data>) {
    makeObservable(this, {
      load: action.bound,
    });
  }

  load() {
    this.meta.state = LoadState.Pending;
    this.promise = this.onLoad()
      .then((data) => {
        runInAction(() => {
          this.meta.state = LoadState.Success;
          this.meta.error = undefined;
          this.meta.data = data;
        });
        return data;
      })
      .catch((error) => {
        runInAction(() => {
          this.meta.state = LoadState.Fail;
          this.meta.error = error;
        });
        throw error;
      });

    return this.promise;
  }

  destroy() {
    this.promise.cancel();
  }
}
