import { SerializableValue, Serializable } from 'types/Serializable';
import toLocalISOString from 'utils/date/toLocalISOString';

export class Log<T extends SerializableValue = SerializableValue> implements Serializable {
  public message: string;
  public name: string;
  public data?: T;
  public createOn: Date;

  constructor(message: string, data?: T) {
    this.name = 'Log';
    this.message = message;
    this.data = data;
    this.createOn = new Date();
  }

  toString() {
    return `${this.name}: ${this.message}`;
  }

  toJSON() {
    return {
      text: this.toString(),
      createOn: toLocalISOString(this.createOn),
      data: this.data,
    };
  }
}
