import { Log } from 'services/Log';
import { BackendError } from 'api/BackendError';
import { ILogger, ErrorLevelTypes } from './Logger.types';
import { convertAnyToError } from './Logger.utils';
import RumProvider from '../Rum/RumProvider';
import { RumError } from '../Rum/RumError';

export class Logger implements ILogger {
  reportInfo(info: Log) {
    RumProvider.sendTimeMark(info.name, undefined, {
      timelineItemName: info.name,
      infoData: info.data,
    });
  }

  reportBackendError(backendError) {
    RumError.logBackendError(backendError);
  }

  reportError(error: Error, errorLevel?: ErrorLevelTypes, additional?: unknown) {
    const errorObj = convertAnyToError(error);
    RumError.logFrontendError(errorObj, errorLevel, additional);
  }

  reportAppErrorOnly(error: Error) {
    if (error instanceof BackendError) {
      return;
    }

    const errorObj = convertAnyToError(error);
    RumError.logFrontendError(errorObj);
  }
}
