import safeStringify from 'fast-safe-stringify';

export const convertAnyToError = (error: unknown): Error => {
  if (error instanceof Error) {
    return error;
  }
  if (typeof error === 'string') {
    return new Error(error);
  }
  return new Error(`Unknown error: ${safeStringify(error)}`);
};
