import { logger } from 'services/Logger';
import { PerformanceMetrika, PerformanceMetrikaEventType } from 'services/PerformanceMetrika';
import RumProvider from '../Rum/RumProvider';

export const performanceMetrika = new PerformanceMetrika();
performanceMetrika.addEventListener(PerformanceMetrikaEventType.BufferFull, (event) => {
  const { detail } = event;
  if (detail && Array.isArray(detail)) {
    detail.forEach((item) => {
      RumProvider.sendTimeMark('crm_performance_metrika', undefined, { metrika: item });
    });
  }
});
performanceMetrika.addEventListener(PerformanceMetrikaEventType.Error, (event) => {
  logger.reportError(event.detail);
});
performanceMetrika.run();

export * from './PerformanceMetrika';
export * from './PerformanceMetrika.types';
export * from './PerformanceMetrikaBufferError';
