import { makeAutoObservable } from 'mobx';
import { PersonalCallObject } from '../../types/PersonalCallData';
import * as api from '../Activities/api';
import { MutationData, PersonalCallService } from './PersonalCallService.types';

export class PersonalCallServiceImpl implements PersonalCallService {
  public isCallDataLoading: boolean;
  public callData: PersonalCallObject;

  private setCallData = (callData: PersonalCallObject) => {
    this.callData = callData;
  };

  public constructor() {
    makeAutoObservable(this);
  }

  public loadCallData = async (id: number) => {
    this.isCallDataLoading = true;
    try {
      const callData = await api.loadCallData(id);
      this.setCallData(callData);
    } catch {
    } finally {
      this.isCallDataLoading = false;
    }
  };

  public reloadCallData = async (id: number) => {
    try {
      const callData = await api.loadCallData(id);
      this.setCallData(callData);
    } catch {}
  };

  public validateData = async (callId: number) => {
    try {
      await api.validateData(callId);
      return;
    } catch (error) {
      return `${error.data?.message ?? error.message}`;
    }
  };

  public mutate = async (id: number, data: MutationData<unknown>) => {
    try {
      const response = await api.mutateActivity({ ...data, id });

      if (response) {
        this.setCallData(response);
      }
    } catch {}
  };

  public getLastNotDoneActivity = async () => {
    try {
      const activity = await api.getLastNotDoneActivity();

      if (activity) {
        this.setCallData(activity);
        return activity;
      }
    } catch {}
  };
}
