import { PersonalCallObject } from '../../types/PersonalCallData';

export interface MutationData<T = unknown> {
  name: string;
  operation: 'add' | 'remove' | 'update';
  value: T;
}

export interface PersonalCallService {
  isCallDataLoading: boolean;
  callData?: PersonalCallObject;
  loadCallData: (id: number) => Promise<void>;
  reloadCallData: (id: number) => Promise<void>;
  validateData: (id: number) => Promise<string | undefined>;
  mutate: (id: number, data: MutationData<unknown>) => Promise<void>;
  getLastNotDoneActivity: () => Promise<PersonalCallObject>;
}
