import React, { createContext, useContext, FC, useMemo } from 'react';
import { PersonalCallService } from './PersonalCallService.types';
import { PersonalCallServiceImpl } from './PersonalCallService';

export const context = createContext<PersonalCallService>(new PersonalCallServiceImpl());

export const Provider = context.Provider;
export const Consumer = context.Consumer;
export const usePersonalCallService = () => useContext(context);

export const PersonalCallServiceProvider: FC = ({ children }) => {
  const service = useMemo(() => new PersonalCallServiceImpl(), []);

  return <Provider value={service}>{children}</Provider>;
};
