import { Account } from 'components/Attribute2/types/Account';
import { MutationData, PersonalCallService } from './PersonalCallService.types';
import { scheme } from './__mocks__/scheme';
import { mutateActivity } from '../Activities/api';
import {
  PersonalCallData,
  PersonalCallObject,
  PersonalCallProps,
} from '../../types/PersonalCallData';

const account: Account = {
  id: 1,
  info: {
    id: 1,
    clientId: 1,
    yatelMcId: '1',
    name: 'Никита Агророза',
    type: 'Клиент',
    login: 'agroroza',
    contractors: [
      {
        id: 2,
        info: {
          id: 2,
          login: 'contractor',
          clientId: 2,
          name: 'contractor',
          yatelMcId: '2',
        },
      },
      {
        id: 3,
        info: {
          id: 3,
          login: 'contractor_3',
          clientId: 3,
          name: 'contractor 3',
          yatelMcId: '3',
        },
      },
    ],
  },
  services: {
    bayan: true,
    direct: true,
    market: true,
    mediasel: true,
    metrika: true,
    sprav: true,
    audience: true,
    balance: true,
    balanceYaTeam: true,
    rsya: true,
    zen: true,
    yaTelephony: true,
  },
  managers: [],
};

const data: PersonalCallData = {
  id: 3453725,
  callId: 'f2ed7713-747b-4b07-b3cf-2ce5891de4c3',
  account: account,
  contactName: 'Ivan',
  phoneNumber: '+79119899102',
  comment: 'this is the comment new one',
  issues: [
    {
      id: 14223622,
      name: 'Входящий звонок',
    },
    {
      id: 14228905,
      name: 'Входящий звонок',
    },
  ],
  isNoIssues: false,
  startTime: '2022-01-11T23:26:01.0000000+03:00',
  duration: 0,
  status: 'Ended',
};

const props: PersonalCallProps = {
  account: {
    access: 0,
  },
  comment: {
    access: 3,
  },
  issues: {
    access: 3,
  },
  isNoIssues: {
    access: 3,
  },
};

export class PersonalCallServiceStub implements PersonalCallService {
  public isCallDataLoading: boolean;
  public callData: PersonalCallObject;

  constructor() {
    this.callData = {
      id: 3453725,
      data,
      scheme,
      props,
    };
    this.isCallDataLoading = false;
  }

  public loadCallData = async () => {};
  public reloadCallData = async () => {};
  public validateData = async (_: number) => Promise.resolve(undefined);
  public getLastNotDoneActivity = async () => ({} as PersonalCallObject);
  public mutate = async (id: number, data: MutationData) => {
    try {
      await mutateActivity({ ...data, id });
    } catch {}
  };
}
