import { AttributesScheme } from '../../../components/AttributesByScheme';

export const scheme: AttributesScheme = [
  {
    component: 'AccountInput',
    name: 'account',
    label: 'Аккаунт',
  },
  {
    component: 'OpportunitiesInput',
    name: 'issues',
    label: 'Сделки',
  },
  {
    component: 'TextInput',
    name: 'comment',
    label: 'Комментарий',
    fieldProps: {
      isMultiline: true,
    },
  },
  {
    component: 'Checkbox',
    name: 'isNoIssues',
    label: 'Не относится к сделке',
  },
];

export const props = {
  account: {
    access: 3,
  },
  comment: {
    access: 3,
  },
  issues: {
    access: 3,
  },
  notRelatedToIssues: {
    access: 3,
  },
};
