import { BackendError } from 'entry/api/BackendError/';
import isEmpty from 'lodash/isEmpty';
export const CONNECTION_ERROR_MESSAGE = 'BackendError: Internet connection error';
export const getMessageFromError = (error: BackendError): string => {
  if (error.status === 0) {
    return CONNECTION_ERROR_MESSAGE;
  }
  if (!isEmpty(error.data)) {
    return `BackendError: ${error.status} ${error.statusText}, message: ${error.data?.message ||
      error.data?.responseStatus?.message}`;
  }
  return `BackendError: ${error.status} ${error.statusText}`;
};
