import guid from 'utils/guid';
import rumProvider from '../RumProvider';
import { UXExperimentConfigType, AdditionalType } from './UXExperiment.types';

export class UXExperiment {
  public isStarted: boolean = false;
  public expId: string;
  public userFlowId: string;
  public userFlowUID: string;
  public additional: AdditionalType = {};
  public startCount: number = 0;
  private config: UXExperimentConfigType;

  constructor(config: UXExperimentConfigType) {
    this.expId = config.expId;
    if (config.additional) {
      this.setAdditional(config.additional);
    }
    this.config = config;
  }
  // TODO: https://st.yandex-team.ru/CRM-16272
  public checkPoint(name: string, time: number, additional: AdditionalType): void {
    if (this.config.startFlow.includes(name)) {
      this.startFlow();
    }
    if (this.userFlowId) {
      rumProvider.sendTimeMark(
        'UXExperiment',
        time,
        this.mergeAdditional({
          name,
          time: Date.now(),
          payload: additional,
        }),
      );
    }

    if (this.config.endFlow.includes(name)) {
      this.endFlow();
    }
  }

  public mergeAdditional(additional): AdditionalType {
    return {
      experiment: this.additional,
      event: additional,
    };
  }

  public startFlow(): void {
    if (!this.isStarted) {
      this.isStarted = true;
      this.startCount++;
      this.userFlowId = `${this.config.expId}_${this.startCount}`;
      this.userFlowUID = `${this.config.expId}_${this.startCount}_${guid()}`;
      this.setAdditional({ userFlowId: this.userFlowId, userFlowUID: this.userFlowUID });
    }
  }

  public setAdditional(additional) {
    this.additional = { ...this.additional, ...additional };
  }

  public endFlow(): void {
    this.isStarted = false;
    this.userFlowId = '';
    this.userFlowUID = '';
    this.setAdditional({ userFlowId: '', userFlowUID: '' });
  }
}

export default UXExperiment;
