import '@yandex-int/rum-counter/dist/inline/interface.min.js';
import '@yandex-int/rum-counter/dist/inline/longtask.min.js';
import '@yandex-int/rum-counter/dist/inline/io.min.js';
import '@yandex-int/error-counter/dist/interfaceOverRum.min';
import '@yandex-int/error-counter/dist/implementation.min';
import '@yandex-int/error-counter/dist/filters.min';
import '@yandex-int/error-counter/dist/logger.min';
import '@yandex-int/error-counter/dist/logError.min';

const page = window.location.hash.split('/')[1]?.split('?')[0];

window.Ya.Rum.init(
  {
    beacon: true,
    clck: 'https://yandex.ru/clck/click',
    slots: [],
    reqid: window.crypto.getRandomValues(new Uint32Array(1))[0].toString(), // уникальный id показа
  },
  {
    region: '213',
    rum_id: 'ru.crm-space.desktop',
    url: window.location.href,
    '-page': page,
    '-project': 'crm-space',
    '-platform': 'desktop',
  },
);

window.Ya.Rum.initErrors({
  project: 'crm-space', // Название проекта
  page: page, // Страница сервиса, например: index, search, product
  host: window.location.host, // Страница сервиса, например: index, search, product
  env: process.env.NODE_ENV, // !! Доступные значения: development, testing, prestable, production
  platform: 'desktop', // !! Доступные значения: desktop, touch, pad, app, tv, tvapp, unsupported
  uncaughtException: false,
});
