import UAParser from 'ua-parser-js';
import { config } from '../Config';
import { blockedBrowsers, minSupportedVersions } from './supportedBrowsers';

export const getIsSupportedBrowser = () => {
  const uaParser = new UAParser();

  const { name, major } = uaParser.getBrowser();

  if (!name || !major) {
    return true;
  }

  return (
    (!blockedBrowsers.includes(name) &&
      (!minSupportedVersions[name] || parseInt(major, 10) >= minSupportedVersions[name]))
  );
};
