import { SvgIconType } from '@crm/components/dist/lego2/Icon/svg';

interface SupportedBrowser {
  name: string;
  minimalVersion: number;
  logo: SvgIconType;
  downloadLink: string;
  key: string;
}

export const supportedBrowsers: SupportedBrowser[] = [
  {
    name: 'Яндекс.Браузер',
    minimalVersion: 20,
    logo: 'yandexBrowser',
    downloadLink: 'https://browser.yandex.ru/',
    key: 'Yandex',
  },
  {
    name: 'Firefox',
    minimalVersion: 68,
    logo: 'firefox',
    downloadLink: 'https://www.mozilla.org/ru/firefox/new/',
    key: 'Firefox',
  },
  {
    name: 'Edge',
    minimalVersion: 94,
    logo: 'edge',
    downloadLink: 'https://www.microsoft.com/en-us/edge',
    key: 'Edge',
  },
];

export const blockedBrowsers = [
  'Chrome',
  'Chromium',
  'IE',
  'Safari',
  'Mobile Safari',
  'Opera',
  'Opera Mobi',
  'Opera Mini',
];

export const minSupportedVersions = supportedBrowsers.reduce((acc, item) => {
  acc[item.key] = item.minimalVersion;
  return acc;
}, {});
