import { makeObservable, observable, computed, action } from 'mobx';
import { VisibilityType } from './VisibilityType';

const visibilityStateToVisibilityType: Record<VisibilityState, VisibilityType> = {
  visible: VisibilityType.Visible,
  hidden: VisibilityType.Hidden,
} as const;

export class TabVisibilityStore {
  private _state: VisibilityType;

  constructor() {
    this.updateVisibilityToCurrent();

    makeObservable<TabVisibilityStore, '_state' | 'updateVisibilityToCurrent'>(this, {
      _state: observable,
      state: computed,
      updateVisibilityToCurrent: action.bound,
    });

    document.addEventListener('visibilitychange', this.updateVisibilityToCurrent);
  }

  destroy() {
    document.removeEventListener('visibilitychange', this.updateVisibilityToCurrent);
  }

  get state() {
    return this._state;
  }

  private updateVisibilityToCurrent() {
    this._state = visibilityStateToVisibilityType[document.visibilityState];
  }
}
