import { ModalView, UIServiceFormProps } from './UserInteractionService';

export class DefaultConfirmModalView implements ModalView {
  public open({ onSubmitSuccess, onClose, title, description }: UIServiceFormProps) {
    const isConfirmed = window.confirm(`${title} ${description ?? ''}`);

    return isConfirmed ? onSubmitSuccess(isConfirmed) : onClose();
  }
}
