import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { ConfirmModalForm } from 'components/ConfirmForm';
import { ModalContainer } from 'lego/utils/modalForm';
import UserInteractionServiceDoc from './UserInteractionService.doc.mdx';
import { UserInteractionService } from './UserInteractionService';

export default {
  title: 'Services/UserInteractionService',
  component: ConfirmModalForm,
  parameters: {
    docs: {
      page: UserInteractionServiceDoc,
    },
  },
};

const getUserInteractionServiceStory = (userInteractionService: UserInteractionService) => {
  return (
    <>
      <Button
        onClick={() => {
          userInteractionService.confirm({ title: 'Вы уверены?' });
        }}
      >
        open modal
      </Button>
      <ModalContainer />
    </>
  );
};

export const fallback = () => {
  const userInteractionService = new UserInteractionService();

  return getUserInteractionServiceStory(userInteractionService);
};

export const withView = () => {
  const userInteractionService = new UserInteractionService();
  userInteractionService.setConfirmView(ConfirmModalForm);

  return getUserInteractionServiceStory(userInteractionService);
};
