import { ModalViewProps, UIModalService } from 'types/ModalService';
import { DefaultConfirmModalView } from './DefaultConfirmModalView';
import { DefaultAlertModalView } from './DefaultAlertModalView';

export interface UIServiceFormProps extends ModalViewProps {
  title: string;
  description?: string;
}

export type ModalView = UIModalService<UIServiceFormProps>;

export class UserInteractionService {
  private confirmView: ModalView;
  private alertView: ModalView;

  public constructor() {
    this.confirmView = new DefaultConfirmModalView();
    this.alertView = new DefaultAlertModalView();
  }

  private async getUserAnswer(
    modalView: ModalView,
    { title = 'Требуется подтверждение', description }: UIServiceFormProps,
  ) {
    return new Promise<unknown>((resolve, reject) => {
      modalView.open({
        onSubmitSuccess: (value: unknown) => {
          resolve(value);
        },
        onClose: () => {
          reject();
        },
        title,
        description,
      });
    });
  }

  private showAlert(modalView: ModalView, { title = '', description }: UIServiceFormProps) {
    return new Promise<unknown>((resolve) => {
      modalView.open({
        onSubmitSuccess: (value: unknown) => {
          resolve(value);
        },
        onClose: () => {
          resolve(undefined);
        },
        title,
        description,
      });
    });
  }

  public setConfirmView = (confirmView: ModalView) => {
    this.confirmView = confirmView;
  };

  public setAlertView = (alertView: ModalView) => {
    this.alertView = alertView;
  };

  public confirm = (props) => {
    return this.getUserAnswer(this.confirmView, props).catch(() => false);
  };

  public alert = (props) => {
    return this.showAlert(this.alertView, props);
  };
}

export const userInteractionService = new UserInteractionService();
