import { makeAutoObservable, onBecomeUnobserved } from 'mobx';
import { UserStatus as UserStatusDTO } from 'types/UserStatus';
import { UserStatusStore } from './UserStatusStore';
import { UserStatus } from './UserStatus';

export class UserStatusImpl implements UserStatus {
  static UNKNOWN_STATUS: UserStatusDTO = {
    id: -1,
    text: 'Неопределен',
    icon: 'help',
    color: '#555',
  };

  userId: number;
  status: UserStatusDTO;
  store: UserStatusStore;

  constructor(store: UserStatusStore, userId: number) {
    makeAutoObservable(this, {
      store: false,
      userId: false,
      destroy: false,
    });

    this.store = store;
    this.status = UserStatusImpl.UNKNOWN_STATUS;
    this.userId = userId;

    onBecomeUnobserved(this, 'status', this.destroy);
  }

  destroy = () => {
    this.store.removeUserStatusById(this.userId);
  };
}
