import { AdaptiveIntervalByTabVisibility } from 'services/AdaptiveInterval';
import { UserStatusStoreImpl } from './UserStatusStoreImpl';
import { UserStatusImpl } from './UserStatusImpl';
import { runAutoSync } from './runAutoSync';

export * from './UserStatus';
export * from './UserStatusImpl';
export * from './UserStatusStore';
export * from './UserStatusStoreImpl';

export const userStatusStore = new UserStatusStoreImpl(UserStatusImpl);

export const DEFAULT_SYNC_USER_STATUS_DELAY = 15 * 1000;

export const runAutoSyncUserStatuses = (delay = DEFAULT_SYNC_USER_STATUS_DELAY) => {
  return runAutoSync(userStatusStore, delay, AdaptiveIntervalByTabVisibility);
};
