import { autorun } from 'mobx';
import debounce from 'lodash/debounce';
import { IntervalConstructor, Interval } from 'services/AdaptiveInterval';
import { UserStatusStore } from './UserStatusStore';

export const DEBOUNCE_DURATION_STATUS_ARRAY_CHANGE = 100;

export const runAutoSync = (
  userStatusStore: UserStatusStore,
  autosyncIntervalDuration: number,
  IntervalImpl: IntervalConstructor,
): (() => void) => {
  let interval: Interval | undefined;

  const cleanTimer = () => {
    interval?.destroy();
    interval = undefined;
  };

  const updateStatuses = debounce((userSizeForStatusSync) => {
    if (userSizeForStatusSync) {
      userStatusStore.syncStatuses();

      if (!interval) {
        interval = new IntervalImpl(() => {
          userStatusStore.syncStatuses();
        }, autosyncIntervalDuration);
      }
    }

    if (!userSizeForStatusSync) {
      cleanTimer();
    }
  }, DEBOUNCE_DURATION_STATUS_ARRAY_CHANGE);

  const disposeAutoRun = autorun(() => {
    updateStatuses(userStatusStore.statuses.size);
  });

  return () => {
    disposeAutoRun();
    cleanTimer();
  };
};
