import { makeAutoObservable } from 'mobx';
import { AsyncTaskState } from 'types/AsyncTaskState';
import { AsyncTaskStatus } from 'types/AsyncTaskStatus';

export class AsyncTask implements AsyncTaskState {
  data: void;
  status: AsyncTaskStatus = AsyncTaskStatus.Idle;
  error?: Error;

  constructor() {
    makeAutoObservable(this);
  }

  idle() {
    this.status = AsyncTaskStatus.Idle;
    this.error = undefined;
  }

  reject(error: Error) {
    this.status = AsyncTaskStatus.Error;
    this.error = error;
  }

  run() {
    this.status = AsyncTaskStatus.Pending;
    this.error = undefined;
  }

  done() {
    this.status = AsyncTaskStatus.Complete;
    this.error = undefined;
  }
}
