import { makeAutoObservable } from 'mobx';
import { VirtualListMeta as IVirtualListMeta, VirtualListItemId } from 'types/VirtualList';

export class VirtualListMeta implements IVirtualListMeta {
  private _firstId: VirtualListItemId = 0;
  private _firstSeqId: number = -1;
  private _lastId: VirtualListItemId = 0;
  private _lastSeqId: number = -1;

  constructor(virtualListMeta?: IVirtualListMeta) {
    makeAutoObservable(this);

    if (virtualListMeta) {
      this.updateFromJson(virtualListMeta);
    }
  }

  get firstId() {
    return this._firstId;
  }

  get firstSeqId() {
    return this._firstSeqId;
  }

  get lastId() {
    return this._lastId;
  }

  get lastSeqId() {
    return this._lastSeqId;
  }

  updateFromJson(virtualListMeta: IVirtualListMeta) {
    if (!this.isNewVersion(virtualListMeta)) {
      return;
    }

    this._firstId = virtualListMeta.firstId;
    this._firstSeqId = virtualListMeta.firstSeqId;
    this._lastId = virtualListMeta.lastId;
    this._lastSeqId = virtualListMeta.lastSeqId;
  }

  private isNewVersion(virtualListMeta: IVirtualListMeta): boolean {
    return virtualListMeta.lastSeqId > this._lastSeqId;
  }
}
