import { makeAutoObservable, action } from 'mobx';
import { WebphoneWidget, WebphoneOutgoingEventKind } from '@yandex-telephony/ya-calls-webphone-sdk';
import { WebphoneEventManager } from 'modules/webphone/services/WebphoneEventManager';

export class WebphoneService {
  public hasActiveCall = false;

  private webphone?: WebphoneWidget;
  private webphoneEventManager?: WebphoneEventManager;

  constructor() {
    makeAutoObservable<WebphoneService, 'handleEstablishedCall' | 'callEnd'>(this, {
      handleEstablishedCall: action.bound,
      callEnd: action.bound,
    });
  }

  destroy() {
    this.webphoneEventManager?.destroy();
  }

  setWebphone(webphone: WebphoneWidget) {
    this.webphone = webphone;
    this.initWebphoneHooks();
  }

  private initWebphoneHooks() {
    if (this.webphone) {
      this.webphoneEventManager = new WebphoneEventManager(this.webphone, {
        [WebphoneOutgoingEventKind.EstablishedCall]: this.handleEstablishedCall,
        [WebphoneOutgoingEventKind.CallEnd]: this.callEnd,
      });
    }
  }

  private handleEstablishedCall() {
    this.hasActiveCall = true;
  }

  private callEnd() {
    this.hasActiveCall = false;
  }
}
