import { XivaMessageAny } from 'types/xiva/XivaWebsocketJSONApi';
import { Log } from 'services/Log';
import { hideSecretValue } from 'utils/hideSecretValue';
import { isXivaServiceMessage, isXivaMethodAny } from './xivaMessageTypeSafeCheck';

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export class XivaClientLog extends Log<any> {
  static secureTokens(message: XivaMessageAny): XivaMessageAny {
    if (isXivaMethodAny(message) && 'sign' in message.params) {
      return {
        ...message,
        params: {
          ...message.params,
          sign: hideSecretValue(message.params.sign),
        },
      } as XivaMessageAny;
    }

    return message;
  }

  static removeBackendPayload(message: XivaMessageAny): XivaMessageAny {
    if (isXivaServiceMessage(message)) {
      return {
        ...message,
        params: {
          ...message.params,
          data: {
            ...message.params.data,
            message: '',
          },
        },
      };
    }

    return message;
  }

  public name = 'XivaClient';

  public readonly xivaMessage: XivaMessageAny;

  constructor(str: string, xivaMessage: XivaMessageAny) {
    super(
      str,
      [XivaClientLog.secureTokens, XivaClientLog.removeBackendPayload].reduce(
        (ac, fn) => fn(ac),
        xivaMessage,
      ),
    );
  }
}
