import { XivaMessageAny } from 'types/xiva/XivaWebsocketJSONApi';
import { Observable, BehaviorSubject } from 'rxjs';
import { XivaClient as IXivaClient } from 'types/xiva/XivaClient';

export class XivaClientNull<T extends XivaMessageAny> implements IXivaClient<T> {
  public messageFromServer = new Observable<T>();
  public isWebsocketOpened = new BehaviorSubject<boolean>(true);

  private emptyObservable = new Observable<T>();

  multiplex() {
    return this.emptyObservable;
  }

  next() {}
}
