import { get } from 'api/common';
import { tabGuid } from 'utils/guid';
import { config } from 'services/Config';
import { XivaSettingBackendData } from 'types/xiva/XivaSettingBackendData';
import { XivaClient } from './XivaClient';
import { XivaClientNull } from './XivaClientNull';

export const createCrmXivaClient = () => {
  if (!config.value.useXiva) {
    return new XivaClientNull();
  }

  function getXivaSettings(options?: { tags?: string; topic?: string }) {
    return get<XivaSettingBackendData>({
      url: '/xiva/settings',
      data: { topic: options?.topic },
    }).then((data) => ({
      ...data,
      topic: options?.topic,
      service: options?.tags ? `${data.service}:${options?.tags}` : data.service,
      session: `${data.user}-${tabGuid}`,
      uid: data.user,
    }));
  }

  return new XivaClient({ getXivaSettings });
};
