import get from 'lodash/get';
import {
  XivaDisconnectedMessage,
  XivaMessageAny,
  XivaSubscribeMethodResponse,
  XivaUnsubscribeMethodResponse,
  XivaNotificationMessageAny,
  XivaNotificationMessage,
  XivaMethodAny,
  XivaPingMethodResponse,
  XivaErrorMessage,
} from 'types/xiva/XivaWebsocketJSONApi';

export const isXivaDisconnectedMessage = (
  message: XivaMessageAny,
): message is XivaDisconnectedMessage => {
  return get(message, ['params', 'data', 'operation']) === 'disconnected';
};

export const isXivaSubscribeMethodResponse = (
  message: XivaMessageAny,
): message is XivaSubscribeMethodResponse => {
  return get(message, ['result', 'operation']) === 'attached';
};

export const isXivaUnsubscribeMethodResponse = (
  message: XivaMessageAny,
): message is XivaUnsubscribeMethodResponse => {
  return get(message, ['result', 'operation']) === 'detached';
};

export const isXivaNotificationMessageAny = (
  message: XivaMessageAny,
): message is XivaNotificationMessageAny => {
  return get(message, ['method']) === '/push';
};

export const isPong = (message: XivaMessageAny): message is XivaPingMethodResponse => {
  return get(message, ['result']) === 'pong';
};

export const CRMOperations = new Set([
  'oc.statusChanged',
  'upsale.updateUpsale',
  'yacalls.predictivedialertransition',
  'issueSetByOverseer',
  'issueSetByOverseerMessage',
  'callNewNotify',
  'contactsChanged',
  'issueCategoryUpdated',
  'pinChecked',
  'timerSkipped',
  'issueCallNewNotify',
  'ycCallUpdated',
  'issueTimelineUpdate',
  'issueModuleRefresh',
  'IssueCounterServiceMessage',
  'ycPersonalCallDialStart',
  'ycPersonalCallStart',
  'ycPersonalCallUpdate',
  'ycPersonalCallEnd',
]);

export const isXivaServiceMessage = (
  message: XivaMessageAny,
): message is XivaNotificationMessage => {
  return (
    get(message, ['method']) === '/push' &&
    CRMOperations.has(get(message, ['params', 'data', 'operation']))
  );
};

const XivaClientMethods = new Set(['/subscribe', '/unsubscribe', '/push']);

export const isXivaMethodAny = (message: XivaMessageAny): message is XivaMethodAny => {
  return XivaClientMethods.has(get(message, ['method']));
};

export const isXivaErrorMessage = (message: XivaMessageAny): message is XivaErrorMessage => {
  return get(message, ['params', 'data', 'operation']) === 'xivaws-error';
};
