export enum ArrayOperation {
  AddItem,
  RemoveItem,
  ChangeItem,
  Clear,
}

export interface WithArrayDiff<T> {
  array: {
    prev: T[];
    next: T[];
  };
}

export interface ArrayOperationClearData<T> extends WithArrayDiff<T> {
  type: ArrayOperation.Clear;
}

export interface ArrayOperationRemoveItemData<T> extends WithArrayDiff<T> {
  type: ArrayOperation.RemoveItem;
  item: T;
}

export interface ArrayOperationAddItemData<T> extends WithArrayDiff<T> {
  type: ArrayOperation.AddItem;
  item: T;
}

export interface ArrayOperationChangeItemData<T> extends WithArrayDiff<T> {
  type: ArrayOperation.ChangeItem;
  item: {
    prev: T;
    next: T;
  };
}

export type ArrayOperationAnyData<T> =
  | ArrayOperationClearData<T>
  | ArrayOperationRemoveItemData<T>
  | ArrayOperationAddItemData<T>
  | ArrayOperationChangeItemData<T>;
