import { UserInfo } from './entities/user';
import { NewDesignObject } from './features/NewDesignObject';

export interface ModuleConfig {
  create: {
    modal: number;
    inline: number;
  };
  search: {
    category: number;
    scope: number;
    state: number;
    resolution: number;
    type: number;
    author: number;
    owner: number;
    onlyActualOwner: number;
    queue: number;
    communication: number;
    clientIdLogin: number;
    inn: number;
    contractNum: number;
    createDate: number;
    deadlineDate: number;
    tag: number;
    currentAmount: number;
    opportunitySource: number;
    plannedCompletionDate: number;
  };
  takeNext: number;
  filters: number;
  sortItems: { value: string; content: string }[];
}

export interface Config {
  app: {
    frontend: string;
    backend: string;
  };
  backendAdminPanelHost: string;
  modules: {
    mcsMail: boolean;
    mcsReview: boolean;
    accountList: boolean;
    account: boolean;
    mail: boolean;
    lift: boolean;
    reports: boolean;
    history: boolean;
    massmail: boolean;
    notifications: boolean;
    telephony: boolean;
    issue: boolean;
    ticket: boolean;
    chat: boolean;
    billing: boolean;
    personalDashboard: boolean;
    adminAccess: {
      categories: boolean;
      users: boolean;
      templates: boolean;
      statface: boolean;
      system: boolean;
      any: boolean;
    };
    settingsAccess: {
      templates: boolean;
      signatures: boolean;
      folders: boolean;
      mailRules: boolean;
      delegations: boolean;
      queues: false;
      supports: boolean;
      other: boolean;
      autoreplies: boolean;
      mailing: boolean;
      tags: boolean;
      accountTags: boolean;
      telephony: boolean;
      issue: false;
      notifications: boolean;
      upsaleRule: boolean;
      any: boolean;
    };
    any: boolean;
  };
  availableDelegations: UserInfo[];
  features: {
    autoAssignIssues: boolean;
    comDepMoney: boolean;
    currency: boolean;
    dtsMailRouting: boolean;
    newDesignObject: NewDesignObject;
    newDesignAttributes: boolean;
    issueTimelineV2: boolean;
    issueHeaderV2: boolean;
    newDesignFilters: boolean;
    useTicketStructuredFilters: boolean;
    useYaCalls: boolean;
    useYaCallsLB: boolean;
    yaCallsLogsCanForcePause: boolean;
    useUserStatuses: boolean;
    massMailImprovements: boolean;
    personalUnits: boolean;
    activityTab: boolean;
    enableInternalChats: boolean;
    categoryTipsExperiment: boolean;
    categoryTipsButtonExperiment: boolean;
    newDesignLift: boolean;
    newFrontendLogs: boolean;
    newRealtimeLimit: boolean;
    newActivitiesDesign: boolean;
    newMessageControls: boolean;
    newEditingFiles: boolean;
    useYfm: boolean;
  };
  hostName: string;
  isAutoreply: boolean;
  showPhoneNumber: boolean;
  teamMembers: UserInfo[];
  testMode: boolean;
  useXiva: boolean;
  user: UserInfo;
  realUser?: UserInfo;
  version: string;
  useExternalPhone: boolean;
  infraPresetId: string;
  config: {
    configMap: {
      Issue: ModuleConfig;
      Opportunity: ModuleConfig;
      Ticket: ModuleConfig;
    };
    intervals: {
      default: number;
      userStatus: number;
      issuesRefresh: number;
      viewNotificationList: number;
      viewUserState: number;
      viewMailListRefresh: number;
    };
    features: {
      logMetrika: boolean;
    };
  };
}

export type InitialLoadData = { nonce: string } & (
  | {}
  | {
      info: Config;
      error: null;
    }
  | {
      info: {};
      error: { name: string; message: string; code?: string };
    }
);
