import { Tag } from 'types';
import { TimelineItemStatus } from 'types/TimelineItemStatus';
import { User } from './entities/user';
import { FileDTO } from './FileDTO';
import { UpsaleFactors } from './entities/upsale';

export enum MailType {
  Inbox = 'Inbox',
  Outbox = 'Outbox',
  Draft = 'Draft',
  Sending = 'Sending',
  Delayed = 'Delayed',
}

export interface MailShortInfo {
  author: User;
  bodyPreview: string;
  dt: string;
  eType: 'Mail';
  hasAttach: boolean;
  id: number;
  isExternal: boolean;
  type: MailType;
  upsaleFactors?: UpsaleFactors;
  tags: Tag[];
}

export interface MailPreview {
  id: number;
  date: string;
  from: string;
  to: string;
  cc: string;
  bcc: string;
  subject: string;
  body: string;
  type: string;
  isHtml: boolean;
  isSpam: boolean;
  files: FileDTO[];
}

export interface Mail {
  author: User;
  id: number;
  date: string;
  from: string;
  to: string;
  cc: string;
  bcc: string;
  subject: string;
  body: string;
  type: MailType;
  isHtml: boolean;
  isSpam: boolean;
  files: FileDTO[];
  isExternal: boolean;
  eType: 'Mail';
  upsaleFactors?: UpsaleFactors;
  hasAttach: boolean;
  status?: TimelineItemStatus;
}
