export interface ModalViewProps {
  onSubmitSuccess: (...rest: unknown[]) => void;
  onClose: () => void;
  onCancel?: () => void;
}

export interface ModalService<P> {
  isMinimized: boolean;
  isVisible?: boolean;
  name: string;
  minimize: () => void;
  maximize: () => void;
  open: (props: P) => void;
  destroy: () => void;
}

export type UIModalService<P> = Pick<ModalService<P>, 'open'>;
