import { Account } from 'components/Attribute2/types/Account';
import { IssueEntity } from './index';
import { AttributesScheme } from '../components/AttributesByScheme';
import { DataObject, FieldProps } from './Attributes';

export interface PersonalCallData {
  id: number; // crm call id
  callId: string; // yacalls call id
  account?: Account;
  contactName: string;
  phoneNumber: string;
  issues: IssueEntity[];
  isNoIssues?: boolean;
  startTime: string;
  duration: number;
  comment: string;
  status: 'Ended' | 'InProgress';
  isDone?: boolean;
}

export type PersonalCallProps = Partial<Record<keyof PersonalCallData, FieldProps>>;

export type PersonalCallSchema = AttributesScheme;

export type PersonalCallObject = DataObject<
  PersonalCallData,
  PersonalCallProps,
  PersonalCallSchema
>;
