import { Attachment } from './Attachment';

export interface TemplateBaseApiDTO {
  bodyHtml: string;
  bodyPlain: string;
  isDefault: boolean;
  type: string;
  typeName: string;
  name?: string;
  files?: Attachment[];
}

export interface TemplateApiDTO extends TemplateBaseApiDTO {
  id: number;
}

export interface TemplateMailApiDTO extends TemplateBaseApiDTO {
  templateId: number;
}

export interface SignatureMailApiDTO extends TemplateBaseApiDTO {
  signatureId: number;
}
