import { Attachment } from './Attachment';

export interface TemplateByType {
  id: string;
  caption: string;
  itemIds: string[];
}

export interface TemplateByGroup {
  id: string;
  caption: string;
  itemIds: string[];
}

export interface TemplateGroupWithItems {
  id: string;
  caption: string;
  items: Template[];
}

export interface Template {
  id: string;
  bodyHtml: string;
  bodyPlain: string;
  isDefault: boolean;
  groupId?: string;
  typeId?: string;
  name?: string;
  files?: Attachment[];
}

export interface TemplateFilter {
  text?: string;
  typeId: string;
}

export type TemplateItemAny = TemplateGroupWithItems | Template;

export interface TemplateProvider {
  getTypes(): TemplateByType[];
  hasTemplate(id: string): boolean;
  getTemplate(id: string): Template;
  getTemplateListByFilter(filter: TemplateFilter): TemplateItemAny[];
}
