import { VirtualListItemId } from './VirtualListItemId';

export type VirtualListGetDirection = 'next' | 'previous';

export interface VirtualListGetOptions {
  /**
   * max count next items
   * */
  limit: number;

  /**
   * include by default
   * */
  fromId?: VirtualListItemId;

  /**
   * exclude from item form result
   * */
  excludeFrom?: boolean;

  /**
   * include by default
   * */
  toId?: VirtualListItemId;

  /**
   * exclude to item form result
   * */
  excludeTo?: boolean;

  exactId?: VirtualListItemId;

  direction?: VirtualListGetDirection;
}
