import { IndexLocationWithAlign } from 'react-virtuoso';
import { AsyncTaskState } from 'types/AsyncTaskState';
import { VirtualListItem } from './VirtualListItem';
import { VirtualListItemId } from './VirtualListItemId';
import { VirtualListMeta } from './VirtualListMeta';

export interface VirtualListServiceLoadInitEdgeOptions {
  from: 'start' | 'end';
}

export interface VirtualListServiceLoadInitCenterOptions<
  T extends VirtualListItem = VirtualListItem
> {
  from: 'center';
  exactId: VirtualListItemId;
  getInitialTopMostItemId: (items: T[]) => VirtualListItemId | null;
}

export type VirtualListServiceLoadInitOptions<T extends VirtualListItem = VirtualListItem> =
  | VirtualListServiceLoadInitEdgeOptions
  | VirtualListServiceLoadInitCenterOptions<T>;

export interface VirtualListService<T extends VirtualListItem = VirtualListItem> {
  init(options: VirtualListServiceLoadInitOptions<T>);
  retryInit();
  retryLoadNext();
  retryLoadPrevious();
  getItemIdByAbsoluteIndex(index: number): VirtualListItemId;
  hasItemByAbsoluteIndex(index: number): boolean;
  getItemByAbsoluteIndex(index: number): T;
  appendNonOrderItems(items: T[]): void;
  updateMeta(meta: VirtualListMeta): void;
  startReached(index: number): void;
  endReached(index: number): void;
  destroy(): void;
  loadInitTask: AsyncTaskState;
  loadNextTask: AsyncTaskState;
  loadPreviousTask: AsyncTaskState;
  firstItemIndex: number;
  hasMorePrevious: boolean;
  hasMoreNext: boolean;
  initialTopMostItemIndex: number | IndexLocationWithAlign;
  length: number;
}
