export interface Column {
  areaId: string;
  blockWidthRatio: number;
  columns?: Column[];
}

export interface Schema {
  rows: Column[];
}

export interface Layout {
  schema: Schema;
  areaIdToBlocksIds: Record<string, string[] | undefined>;
}

export interface Block {
  componentType: string;
  title: string;
  url: string;
}

export interface Tab {
  tabId: number;
  tabCaption: string;
  layout: Layout;
  blocks: Record<string, Block>;
}

export interface Tabs {
  data: {
    tabs: Tab[];
  };
}
