export interface Field<SchemeMeta, SchemeData> {
  meta: SchemeMeta;
  data: SchemeData;
  merged: SchemeMeta & SchemeData;
}

export interface FieldMeta {
  id: string;
  title?: string;
  type: string;
  access: number;
  sortable?: boolean;
  isPinned?: boolean;
  columnWidth?: string;
  options?: unknown;
  isFieldsUpdateNeeded: boolean;
  isOptionalSending?: boolean;
}

export interface FieldData<V> {
  id: string;
  type: string;
  data?: V;
}
