import { Services } from 'components/ClientExternalLinks';
import { User } from 'types/entities/user';
import { Field, FieldMeta, FieldData } from '../Field';

export interface Account {
  id: string;
  login: string;
  name: string;
  type: string;
}

export interface AccountShortInfo {
  id: number;
  tierName?: string;
  info: {
    zenPublisherIds?: (string | number)[];
    yatelMcId: string;
    clientId: number;
    type?: string;
  };
  managers?: User[];
  services: Services;
  agency?: string;
  contragentName?: string;
}

export type AccountField = Field<FieldMeta, FieldData<Account>>;
