import { UserField } from './User';
import { AccountField } from './Account';
import { TextField } from './Text';
import { CheckboxField } from './Checkbox';
import { CustomViewField } from './CustomView';
import { TextareaField } from './Textarea';
import { SelectField } from './Select';
import { SelectArrayField } from './SelectArray';
import { SuggestField } from './Suggest';
import { SuggestArrayField } from './SuggestArray';
import { MoneyField } from './Money';
import { LinkField } from './Link';
import { PercentField } from './Percent';
import { DiffField } from './Diff';
import { DigitField } from './Digit';
import { ButtonField } from './Button';
import { RowActionField } from './RowAction';
import { ListField } from './List';
import { EmptyField } from './Empty';
import { DateTimeField } from './DateTime';
import { AvailabilityPeriodsField } from './AvailabilityPeriods';
import { TagField } from './Tag';
import { SuggestTagArrayField } from './SuggestTagArray';
import { AudioField } from './Audio';

export interface Fields {
  Account: AccountField;
  User: UserField;
  Text: TextField;
  Checkbox: CheckboxField;
  CustomView: CustomViewField<unknown>;
  Textarea: TextareaField;
  Select: SelectField;
  SelectArray: SelectArrayField;
  BusinessPlacementFrequency: SelectArrayField;
  Suggest: SuggestField;
  SuggestArray: SuggestArrayField;
  SuggestUsers: SuggestField;
  SuggestUsersArray: SuggestArrayField;
  Money: MoneyField;
  Percent: PercentField;
  Digit: DigitField;
  Diff: DiffField;
  Link: LinkField;
  Tag: TagField;
  SuggestTagArray: SuggestTagArrayField;
  Button: ButtonField;
  RowAction: RowActionField;
  List: ListField;
  Empty: EmptyField;
  DateTime: DateTimeField;
  AvailabilityPeriods: AvailabilityPeriodsField;
  Audio: AudioField;
}
