import { Fields } from './Fields';
import { UserFilterAny } from './UserFilter';

export type FieldMetaAny = {
  [K in keyof Fields]: Fields[K]['meta'];
}[keyof Fields];

export type FieldDataAny = {
  [K in keyof Fields]: Fields[K]['data'];
}[keyof Fields];

export type FieldAny = FieldMetaAny & Pick<FieldDataAny, 'data'>;

export interface DataSet {
  id: string;
  fields: FieldDataAny[];
  url?: string;
}

export interface PaginationPage {
  caption: string;
  url: string;
}

export interface Pagination {
  page: number;
  pageSize: number;
  pages: PaginationPage[];
}

export interface CreateAction {
  access: number;
  title?: string;
  defaultFields?: FieldDataAny[];
}

export type SortOrder = 'Asc' | 'Desc';

export interface SortObject {
  id: string;
  order: SortOrder;
}

export interface FormAction {
  id: string;
  caption: string;
  actionMethod?: 'POST' | 'DELETE' | 'PUT' | 'PATCH' | 'GET';
  formCaption?: string;
  buttonType?: 'Button' | 'Dropdown';
  isConfirm: boolean;
  confirmCaption?: string;
  isForm: boolean;
  actionUrl?: string;
  customUrl?: string;
  refreshMode: 'ApplyResultData' | 'ReloadAffectedRows' | 'ReloadGrid';
  mode: 'Bulk' | 'Row' | 'Action';
  order: number;
  isReport: boolean;
  reportType?: string;
  viewType?: string;
  parentActionId?: string;
}

export interface Form {
  meta: {
    actions?: FormAction[];
    createAction?: CreateAction;
    fieldsVisibility: string[];
    fields: FieldMetaAny[];
    title?: string;
  };
  filters?: {
    userFilters?: Record<string, UserFilterAny>;
    templateFilters?: number[];
  };
  sort?: SortObject[];
  data: DataSet[];
  gridPagination?: Pagination;
}
