import { User } from 'types/entities/user';
import { Option } from '../Fields/Option';
import { TreeNode } from '../Fields/TreeNode';

export interface GeneralSuggestItem {
  id?: number | string;
}

export interface GeneralSuggestData<T extends GeneralSuggestItem> {
  value: T[];
}

export interface MatchNumberData {
  value: number;
}

export interface ContainsStringData {
  value: string;
}

export interface TreeSuggestMultipleData {
  value: TreeNode[];
}

export interface RangeNumberData {
  from: number;
  to: number;
}

export interface SuggestMultipleData extends GeneralSuggestData<Option> {
  value: Option[];
}

export interface SuggestUsersData extends GeneralSuggestData<User> {
  value: User[];
}

export type UserFilterSearchType = 'Equal' | 'NotEqual' | 'Empty' | 'NotEmpty';

type UserFilterDataCollection =
  | MatchNumberData
  | ContainsStringData
  | RangeNumberData
  | SuggestMultipleData
  | SuggestUsersData;

export type UserFilterAny = UserFilter<UserFilterDataCollection>;

export interface UserFilter<T> {
  type: string;
  provider?: string;
  enableSearchExtension?: boolean;
  searchType?: UserFilterSearchType;
  data?: T;
}
